/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSetting;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobBeekeeper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingBeekeeper
extends AbstractBuildingWorker {
    public static final ISettingKey<StringSetting> MODE = new SettingKey<StringSetting>(StringSetting.class, new ResourceLocation("minecolonies", "beekeeper"));
    public static final String HONEYCOMB = "com.minecolonies.core.apiary.setting.honeycomb";
    public static final String HONEY = "com.minecolonies.core.apiary.setting.honey";
    public static final String BOTH = "com.minecolonies.core.apiary.setting.both";
    private static final String BEEKEEPER = "beekeeper";
    private Set<BlockPos> hives = new HashSet<BlockPos>();

    public BuildingBeekeeper(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> Items.field_151097_aZ == stack.func_77973_b(), new Tuple((Object)1, (Object)true));
        this.keepX.put(stack -> Items.field_151069_bo == stack.func_77973_b(), new Tuple((Object)4, (Object)true));
        this.keepX.put(stack -> ItemTags.field_226159_I_.func_230235_a_((Object)stack.func_77973_b()), new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobBeekeeper(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return BEEKEEPER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Dexterity;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Adaptability;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.beekeeper;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BEEKEEPER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        NBTUtils.streamCompound(compound.func_150295_c("hives", 10)).map(NBTUtil::func_186861_c).forEach(this.hives::add);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_218657_a("hives", (INBT)this.hives.stream().map(NBTUtil::func_186859_a).collect(NBTUtils.toListNBT()));
        return nbt;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
    }

    public Set<BlockPos> getHives() {
        return Collections.unmodifiableSet(new HashSet<BlockPos>(this.hives));
    }

    public void removeHive(BlockPos pos) {
        this.hives.remove(pos);
    }

    public void addHive(BlockPos pos) {
        this.hives.add(pos);
    }

    public String getHarvestTypes() {
        return this.getSetting(MODE).getValue();
    }

    public int getMaximumHives() {
        return (int)Math.pow(2.0, this.getBuildingLevel() - 1);
    }

    public static class View
    extends AbstractBuildingWorkerView {
        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        @Nullable
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingBeekeeper.BEEKEEPER);
        }
    }
}

